/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.item.camera;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.server.CameraInstance;
import io.github.mortuusars.exposure.server.CameraInstances;
import io.github.mortuusars.exposure.world.camera.component.ShutterSpeed;
import io.github.mortuusars.exposure.world.entity.CameraHolder;
import io.github.mortuusars.exposure.world.item.camera.ShutterState;
import io.github.mortuusars.exposure.world.sound.Sound;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.apache.logging.log4j.util.TriConsumer;

public class Shutter {
    protected TriConsumer<CameraHolder, class_3218, class_1799> onOpen = (entity, level, stack) -> {};
    protected TriConsumer<CameraHolder, class_3218, class_1799> onClosed = (entity, level, stack) -> {};

    public void onOpen(TriConsumer<CameraHolder, class_3218, class_1799> onOpen) {
        this.onOpen = onOpen;
    }

    public void onClosed(TriConsumer<CameraHolder, class_3218, class_1799> onClosed) {
        this.onClosed = onClosed;
    }

    public ShutterState getState(class_1799 stack) {
        return (ShutterState)stack.method_57825(Exposure.DataComponents.SHUTTER_STATE, (Object)ShutterState.CLOSED);
    }

    public void setState(class_1799 stack, ShutterState shutterState) {
        stack.method_57379(Exposure.DataComponents.SHUTTER_STATE, (Object)shutterState);
    }

    public boolean isOpen(class_1799 stack) {
        return this.getState(stack).isOpen();
    }

    public boolean shouldClose(class_1799 stack, long gameTime) {
        ShutterState state = this.getState(stack);
        boolean projecting = CameraInstances.getOptional(stack).map(CameraInstance::isWaitingForProjection).orElse(false);
        return state.isOpen() && !projecting && gameTime >= state.getCloseTick();
    }

    public void tick(CameraHolder holder, class_3218 level, class_1799 stack) {
        long gameTime = holder.asHolderEntity().method_37908().method_8510();
        if (this.shouldClose(stack, gameTime)) {
            ShutterState state = this.getState(stack);
            if (gameTime - state.getCloseTick() > 200L) {
                this.setState(stack, ShutterState.CLOSED);
            } else {
                this.close(holder, level, stack);
            }
        }
    }

    public void open(CameraHolder holder, class_3218 level, class_1799 stack, ShutterSpeed shutterSpeed) {
        this.setState(stack, ShutterState.open(level.method_8510(), shutterSpeed));
        holder.asHolderEntity().method_32876((class_6880)class_5712.field_28146);
        this.playOpenSound(holder);
        this.onOpen.accept((Object)holder, (Object)level, (Object)stack);
    }

    public void close(CameraHolder holder, class_3218 level, class_1799 stack) {
        this.setState(stack, ShutterState.closed());
        holder.asHolderEntity().method_32876((class_6880)class_5712.field_28146);
        this.playCloseSound(holder);
        this.onClosed.accept((Object)holder, (Object)level, (Object)stack);
    }

    public void playOpenSound(CameraHolder holder) {
        class_1297 entity = holder.asHolderEntity();
        Sound.play(entity, Exposure.SoundEvents.SHUTTER_OPEN.get(), entity.method_5634(), 0.7f, 1.1f, 0.2f);
    }

    public void playCloseSound(CameraHolder holder) {
        class_1297 entity = holder.asHolderEntity();
        Sound.play(entity, Exposure.SoundEvents.SHUTTER_CLOSE.get(), entity.method_5634(), 0.7f, 1.1f, 0.2f);
    }
}

